package com.bytesbee.mysinglelivechannel.managers;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;

import com.bytesbee.mysinglelivechannel.models.Setting;
import com.bytesbee.mysinglelivechannel.models.User;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.google.gson.Gson;


/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class SessionManager {
    // Shared preferences file name
    private static final String PREF_NAME = "BytesBeeLiveTVV1";
    private static final String KEY_MODEL_USER_DATA = "user_data";
    private static final String KEY_MODEL_SETTING_DATA = "setting_data";
    private static final String KEY_IS_LOGGED_IN = "isLoggedIn";
    private static final String KEY_FCM_TOKEN = "fcmToken";
    private static final String KEY_ON_OFF_NOTIFICATION = "onOffNotification";
    private static final String KEY_ON_OFF_RTL = "onOffRTL";
    private static final String KEY_ON_OFF_FULLSCREEN = "onOffFullscreen";
    private SharedPreferences pref;

    //============== START

    private static SessionManager mInstance;

    public static SessionManager get() {
        return mInstance;
    }

    public static void init(Context ctx) {
        if (mInstance == null) mInstance = new SessionManager(ctx);
    }

    //============== END
    public SessionManager(final Context context) {
        try {
            String masterKey = MasterKeys.getOrCreate(MasterKeys.AES256_GCM_SPEC);
            pref = EncryptedSharedPreferences.create(
                    context.getPackageName() + PREF_NAME,
                    masterKey,
                    context,
                    EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV,
                    EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM
            );
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public void setLogin(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_IS_LOGGED_IN, value);
        editor.apply();
    }

    public boolean isNotLoggedIn() {
        return pref.getBoolean(KEY_IS_LOGGED_IN, false);
    }

    public void setOnOffNotification(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_NOTIFICATION, value);
        editor.apply();
    }

    public boolean isNotificationOn() {
        return pref.getBoolean(KEY_ON_OFF_NOTIFICATION, true);
    }

    public void setOnOffRTL(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_RTL, value);
        editor.apply();
    }

    public boolean isRTLOn() {
        return pref.getBoolean(KEY_ON_OFF_RTL, false);
    }

    public void setOnOffFullscreen(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_FULLSCREEN, value);
        editor.apply();
    }

    public boolean isFullscreenOn() {
        return pref.getBoolean(KEY_ON_OFF_FULLSCREEN, false);
    }

    public User getUserModel() {
        String data = pref.getString(KEY_MODEL_USER_DATA, "");
        return new Gson().fromJson(data, User.class);
    }

    public void setUserModel(User user) {
        final Editor editor = pref.edit();
        String json = new Gson().toJson(user);
        editor.putString(KEY_MODEL_USER_DATA, json);
        editor.apply();
    }

    public Setting getSettingModel() {
        String data = pref.getString(KEY_MODEL_SETTING_DATA, "");
        return new Gson().fromJson(data, Setting.class);
    }

    public void setSettingModel(Setting user) {
        final Editor editor = pref.edit();
        String json = new Gson().toJson(user);
        editor.putString(KEY_MODEL_SETTING_DATA, json);
        editor.apply();
    }

    public String getFCMToken() {
        return pref.getString(KEY_FCM_TOKEN, "");
    }

    public void setFCMToken(String value) {
        final Editor editor = pref.edit();
        editor.putString(KEY_FCM_TOKEN, value);
        editor.apply();
    }

    public void clearAll() {
        setLogin(false);
        setOnOffNotification(true);
        setOnOffRTL(false);
        setOnOffFullscreen(false);
    }
}
